# -*- coding: utf-8 -*-
"""AdaBoost.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1o29Yhjq5NsK3G_a8IArhk6sjJ3V6b_2g
"""

from sklearn.ensemble import AdaBoostClassifier
from sklearn.tree import DecisionTreeClassifier
from sklearn.datasets import make_classification
from sklearn.model_selection import train_test_split
from sklearn.metrics import accuracy_score, classification_report

# Generate synthetic data
X, y = make_classification(n_samples=1000, n_features=20, n_informative=15,
                         n_redundant=5, random_state=42)

# Split data
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.3, random_state=42)

# Create base estimator (typically a weak learner)
base_estimator = DecisionTreeClassifier(max_depth=1)  # Commonly called a "decision stump"

# Create AdaBoost classifier
adaboost_clf = AdaBoostClassifier(
    # Changed base_estimator to estimator based on recent scikit-learn versions
    estimator=base_estimator,
    n_estimators=50,       # Number of weak learners
    learning_rate=1.0,     # Contribution of each classifier
    # Changed 'SAMME.R' to 'SAMME' as required by the error message
    # algorithm='SAMME',   # For discrete boosting
    random_state=42
)

# Train the model
adaboost_clf.fit(X_train, y_train)

# Make predictions
y_pred = adaboost_clf.predict(X_test)

# Evaluate
print(f"AdaBoost Classifier Accuracy: {accuracy_score(y_test, y_pred):.4f}")
print("\nClassification Report:")
print(classification_report(y_test, y_pred))

# Feature importances
print("\nFeature Importances:")
for i, importance in enumerate(adaboost_clf.feature_importances_):
    print(f"Feature {i}: {importance:.4f}")